<?php

$quality_settings = [
    'quality1' => '480',
    'quality2' => '720',
    'quality3' => '1080'
];

file_put_contents('data/quality_settings.json', json_encode($quality_settings));

function getQualitySettings() {
    if(file_exists('data/quality_settings.json')) {
        return json_decode(file_get_contents('data/quality_settings.json'), true);
    }
    return [
        'quality1' => '480',
        'quality2' => '720',
        'quality3' => '1080'
    ];
}

function updateQualitySettings($new_settings) {
    file_put_contents('data/quality_settings.json', json_encode($new_settings));
}
?>